/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.RenameAttribute;

public class RenameAttributeTest
extends AbstractFilterTest {
    public RenameAttributeTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return new RenameAttribute();
    }

    public Filter getFilter(String find, String replace, boolean all, String range, boolean invert) {
        RenameAttribute result = new RenameAttribute();
        result.setFind(find);
        result.setReplace(replace);
        result.setReplaceAll(all);
        result.setAttributeIndices(range);
        result.setInvertSelection(invert);
        return result;
    }

    protected Instances performTest() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RenameAttributeTest.fail("Exception thrown on setInputFormat(): \n" + ex.getMessage());
        }
        try {
            result = Filter.useFilter(icopy, this.m_Filter);
            RenameAttributeTest.assertNotNull(result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RenameAttributeTest.fail("Exception thrown on useFilter(): \n" + ex.getMessage());
        }
        RenameAttributeTest.assertEquals(icopy.numAttributes(), result.numAttributes());
        RenameAttributeTest.assertEquals(icopy.numInstances(), this.m_Instances.numInstances());
        return result;
    }

    public static Test suite() {
        return new TestSuite(RenameAttributeTest.class);
    }

    public void testReplaceFirst() {
        this.m_Filter = this.getFilter("t", "_", false, "first-last", false);
        Instances result = this.performTest();
        RenameAttributeTest.assertEquals("S_ringAtt1", result.attribute(0).name());
    }

    public void testReplaceAll() {
        this.m_Filter = this.getFilter("t", "_", true, "first-last", false);
        Instances result = this.performTest();
        RenameAttributeTest.assertEquals("S_ringA__1", result.attribute(0).name());
    }

    public void testInvertRange() {
        this.m_Filter = this.getFilter("t", "_", true, "first", true);
        Instances result = this.performTest();
        RenameAttributeTest.assertTrue("The first attribute contains '_'!", result.attribute(0).name().indexOf("_") == -1);
    }

    public void testGroup() {
        this.m_Filter = this.getFilter("(.+)(Att)(.+)", "$1$3", true, "first-last", false);
        Instances result = this.performTest();
        int i = 0;
        while (i < result.numAttributes()) {
            RenameAttributeTest.assertTrue(String.valueOf(result.attribute(i).name()) + " still contains 'Att'", result.attribute(i).name().indexOf("Att") == -1);
            ++i;
        }
    }

    public static void main(String[] args) {
        TestRunner.run(RenameAttributeTest.suite());
    }
}

